function [traj]=draw_planar_arm(t,X)
dt=t(2)-t(1);
fig=figure('color',[1 1 1],'Position',[0,0,1000,700]);
traj=zeros(2,numel(t));
for i=1:numel(t)
traj(:,i)=X(i).X(:,3);
end
xmax=max(traj(1,:))*1.2;
xmin=-0.2;
ymax=max(traj(2,:))*1.2;
ymin=-0.5;
for i=1:numel(t)
tic;
    clf
grid on;
hold on;
%first plot arm

% rectangle('position',[-0.25 -0.05 0.3 0.1],'curvature',[0.7 0.7],'FaceColor',[202 225 255]/255);
% rectangle('position',[-0.15 -0.06 0.1 0.12],'curvature',[1 1],'FaceColor',[202 225 255]/255);
plot(X(i).X(1,:),X(i).X(2,:),'k','LineWidth',4);
traj(:,i)=X(i).X(:,3);
plot(traj(1,1:i),traj(2,1:i),'--r','LineWidth',3);
text(xmax,ymax,[' t=',num2str((i-1)*dt),'s'])
        axis([xmin xmax ymin ymax])
        set(gca,'DataAspectRatio',[1 1 1]);
drawnow
k=toc;
pause(dt-k);
end

end